/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class CosineH
extends PostfixMathCommand {
    public CosineH() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.cosh(param));
    }

    public Object cosh(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).cosh();
        }
        if (param instanceof Number) {
            double value = ((Number)param).doubleValue();
            return new Double((Math.exp(value) + Math.exp(-value)) / 2.0);
        }
        throw new ParseException("Invalid parameter type");
    }
}

